/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_SLOT_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class AttenteEvenementSlot {
    private static Logger log = Logger.getLogger(AttenteEvenementSlot.class);

    public static Resultat traitementP11(PKCS11 pKCS11, boolean bl) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                ResultatInfo resultatInfo = new ResultatInfo("Attente d'un \u00e9v\u00e8nement slot (C_WaitForSlotEvent)");
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                resultatInfo.setInfos(linkedHashMap);
                Long l = null;
                try {
                    l = pKCS11.C_WaitForSlotEvent(bl ? 0L : 1L, null);
                    linkedHashMap.put("Identifiant du slot sur lequel un \u00e9v\u00e8nement est survenu", Long.toString(l));
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultatInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                }
                if (l != null) {
                    CK_SLOT_INFO cK_SLOT_INFO = null;
                    try {
                        cK_SLOT_INFO = pKCS11.C_GetSlotInfo(l.longValue());
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        // empty catch block
                    }
                    if (cK_SLOT_INFO != null) {
                        if ((cK_SLOT_INFO.flags & 1L) != 0L) {
                            resultatInfo.setTraitement(resultatInfo.getTraitement() + " de type Insertion");
                        } else {
                            resultatInfo.setTraitement(resultatInfo.getTraitement() + " de type Retrait");
                        }
                    }
                }
                return resultatInfo;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(4, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(4, "Une erreur inattendue est survenue");
        }
    }
}

